# Sica Content AI for WordPress

**Automatic AI-written content that helps small businesses rank in Google and AI search—directly inside WordPress.**

Generate professional SEO-focused blog posts with featured images on flexible subscription plans. Perfect for small businesses, marketing agencies, and content creators who need consistent, high-quality content.

## Description

Sica Content AI for WordPress automatically creates SEO-optimized blog posts using advanced AI technology. The plugin integrates seamlessly with your WordPress dashboard, allowing you to generate engaging content with just a few clicks.

### Key Features

* **AI-Powered Content Generation** - Create full blog posts using OpenAI's latest models
* **SEO Optimization** - Built-in keyword integration and search engine optimization
* **Featured Image Generation** - Automatically creates relevant images for every post
* **Content Enhancement Tools** - Expand and improve existing content with AI
* **Automated Scheduling** - Set up automatic post publishing on your preferred schedule
* **Multiple Subscription Tiers** - From free to professional plans
* **Business Context Integration** - Tailors content to your industry and location
* **Email Notifications** - Get notified when new posts are published
* **WordPress Integration** - Works seamlessly with both Classic and Gutenberg editors

### Perfect For

* **Small Businesses** - Maintain a consistent blog without hiring writers
* **Marketing Agencies** - Scale content creation for multiple clients
* **Content Creators** - Overcome writer's block and boost productivity
* **WordPress Developers** - Offer content solutions to clients
* **Entrepreneurs** - Focus on business while maintaining SEO presence

## Installation

### From WordPress Admin

1. Navigate to **Plugins > Add New** in your WordPress admin
2. Search for "Sica Content AI"
3. Click **Install Now** and then **Activate**
4. Go to **Content AI** in your admin menu to get started

### Manual Installation

1. Download the plugin zip file
2. Upload to `/wp-content/plugins/` directory
3. Extract the files
4. Activate through the **Plugins** menu in WordPress
5. Navigate to **Content AI** to configure

## Getting Started

### Initial Setup

1. **Account Creation**: Enter your email address to create a free account
2. **Business Context**: Add your business name, category, and service area
3. **Content Planning**: Generate keyword suggestions and blog title ideas
4. **First Post**: Create your first AI-generated blog post

### Subscription Plans

#### 🆓 Content AI Lite (Free)
* 2 AI blog posts per month
* Basic SEO optimization
* Watermarked featured images
* Email support

#### 🚀 Paid Plans (Starting at $19/month)
* Up to 50+ posts per month, multiple sites
* Advanced AI models with web search
* High-quality featured images
* Automated scheduling
* Content enhancement tools
* Priority support

## Features in Detail

### Content Generation
* **Smart Prompts** - Industry-specific content templates
* **SEO Integration** - Automatic keyword optimization
* **Local SEO** - Location-based content customization
* **Multiple Formats** - Various post types and structures

### Content Enhancement Tools (Pro)
* **SEO Enhance** - Optimize existing content for search engines
* **Content Expansion** - Add depth and detail to existing posts
* **Featured Image Generation** - Create new images for existing posts

### Scheduling & Automation
* **Flexible Scheduling** - Daily, weekly, or monthly posting
* **Queue Management** - Plan content in advance
* **Automatic Publishing** - Set it and forget it content creation

### WordPress Integration
* **Gutenberg Support** - Works with the block editor
* **Classic Editor** - Full compatibility with classic editor
* **Custom Post Types** - Supports various post formats
* **User Permissions** - Respects WordPress user roles

## Requirements

* **WordPress**: 5.8 or higher
* **PHP**: 7.4 or higher
* **Internet Connection**: Required for AI content generation
* **SSL Certificate**: Recommended for secure communication

## Privacy & External Services

This plugin connects to the Sica Content AI service (api.sica.ai) to:
* Generate blog content using advanced AI models
* Create featured images
* Provide SEO optimization
* Handle subscription management

**Data Handling:**
* Your site URL and email are required for service activation
* Content requests include your specified topics and business context
* No personal data is stored beyond what's necessary for service delivery
* All data handling complies with GDPR and privacy regulations

**External APIs Used:**
* Sica AI Service (api.sica.ai) - Content generation and management
* OpenAI API (via Sica proxy) - AI text generation
* Image generation services (via Sica proxy) - Featured image creation

By using this plugin, you consent to these external service integrations as necessary for the plugin's functionality.

## Frequently Asked Questions

### How does the AI content generation work?
The plugin uses modern AI models to create original, SEO-optimized content based on your business context, keywords, and specified topics. All AI processing is handled securely through our service.

### Can I edit the generated content?
Absolutely! All generated content appears as regular WordPress posts that you can edit, modify, or enhance using the built-in Content AI Tools.

### What happens if I exceed my monthly post limit?
Free users are limited to 2 posts per month. Paid subscribers can upgrade their plan or wait until the next billing cycle. The plugin will notify you when approaching limits.

### Is the content original and SEO-friendly?
Yes, all content is generated fresh for your specific business and optimized for search engines. The AI creates original content tailored to your industry and location.

### Can I use this with other WordPress plugins?
Yes, Sica Content AI is designed to work alongside other WordPress plugins. It integrates seamlessly with popular SEO plugins, page builders, and other content tools.

### What support is available?
* **Free users**: Documentation and community support
* **Paid subscribers**: Email support with priority response
* **Pro users**: Priority chat support and phone assistance

## Support

For support, documentation, and feature requests:

* **Documentation**: Visit our comprehensive knowledge base
* **Support Email**: Contact our support team
* **WordPress.org Forum**: Community support and discussions

## Privacy Policy

We take your privacy seriously. This plugin:
* **Collects minimal data** - Only what's necessary for service delivery
* **Requires explicit consent** - Clear opt-in for all communications
* **Provides transparency** - Full disclosure of data usage
* **Offers control** - Easy unsubscribe and data management options
* **Complies with regulations** - GDPR, CCPA, and other privacy laws

For full details, see our Privacy Policy at https://sica.ai/privacy

## License

This plugin is licensed under the GPL v2 or later.

## Changelog

### 1.2.1
* **Critical fix:** Added "started" activity log entries for all post generation attempts
* **Better tracking:** Manual and scheduled posts now log their start time before processing begins
* **Improved debugging:** Can now see if posts fail before reaching the generation function or during early validation

### 1.2.0
* **Unified Activity Log:** Consolidated all logging into single, comprehensive Activity Log
* **Source tracking:** Activity Log now shows whether posts were created manually or by scheduler (with 👤 and 🤖 icons)
* **Increased retention:** Activity Log stores up to 100 entries (increased from 50)
* **Code cleanup:** Removed duplicate logging code across multiple files
* **Simplified Debug Viewer:** Streamlined debug log viewer to focus on technical file logs
* **Better organization:** Clear separation between activity logs (user-facing) and debug logs (technical)

### 1.1.9
* **Added Debug Log Viewer:** New admin page to view logs without FTP access (Content AI → Debug Logs)
* **Database logging fallback:** Errors now logged to database if file permissions fail
* **Improved debugging:** Logs viewable directly in WordPress admin
* **Permissions troubleshooting:** Debug page shows file permissions and log locations
* **Always accessible:** Database logs work even without WP_DEBUG or file access

### 1.1.8
* **Major improvement:** Added comprehensive error logging and debugging capability
* Implemented smart logging utility that respects WP_DEBUG settings
* Enhanced scheduler error reporting with detailed failure information
* Improved exception handling to capture and log full error context
* Added automatic log rotation (7-day retention)
* Critical fix: Scheduler now logs specific error details instead of generic "returned false" messages
* Better diagnostics for production issues and faster debugging

### 1.1.3
* Enhanced AI content generation with improved prompts
* Added Content AI Tools for post enhancement
* Improved subscription management interface
* Better error handling and user feedback
* Performance optimizations

### 1.1.2
* Added automated scheduling features
* Enhanced subscription interface
* Improved email notifications
* Bug fixes and stability improvements

### 1.1.1
* Initial WordPress.org release
* Core content generation functionality
* Subscription management system
* Featured image generation

## Credits

Developed by Sica.ai - Helping small businesses succeed with AI-powered content creation.

**Built with ❤️ for the WordPress community**