jQuery(document).ready(function($) {
    var isDropdownOpen = false;
    var isProcessing = false;
    
    // Toggle dropdown menu
    $(document).on('click', '.ai-blogger-tools-btn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        if (isProcessing) return;
        
        var dropdown = $(this).siblings('.ai-blogger-dropdown');
        
        if (isDropdownOpen) {
            dropdown.hide();
            isDropdownOpen = false;
        } else {
            // Hide any other open dropdowns first
            $('.ai-blogger-dropdown').hide();
            dropdown.show();
            isDropdownOpen = true;
        }
    });
    
    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.ai-blogger-tools-wrapper').length) {
            $('.ai-blogger-dropdown').hide();
            isDropdownOpen = false;
        }
    });
    
    // Handle enhancement actions
    $(document).on('click', '.ai-enhance-content', function(e) {
        e.preventDefault();
        handleEnhancement('enrich');
    });
    
    $(document).on('click', '.ai-add-faq', function(e) {
        e.preventDefault();
        handleEnhancement('faq');
    });
    
    $(document).on('click', '.ai-improve-seo', function(e) {
        e.preventDefault();
        handleEnhancement('seo');
    });
    
    function handleEnhancement(type) {
        if (isProcessing) return;
        
        // Close dropdown
        $('.ai-blogger-dropdown').hide();
        isDropdownOpen = false;
        
        // Get current content from editor
        var content = getCurrentEditorContent();
        if (!content || content.trim() === '') {
            alert('Please add some content to your post before enhancing it.');
            return;
        }
        
        // Get post ID
        var postId = $('.ai-blogger-tools-btn').data('post-id');
        if (!postId) {
            alert('Unable to determine post ID. Please save your post first.');
            return;
        }
        
        // Show loading state
        showLoadingState(type);
        
        // Make AJAX request
        $.ajax({
            url: aiEnhancer.ajax_url,
            type: 'POST',
            data: {
                action: 'ai_enhance_content',
                nonce: aiEnhancer.nonce,
                post_id: postId,
                content: content,
                enhancement_type: type
            },
            timeout: 180000, // 3 minutes
            success: function(response) {
                hideLoadingState();
                
                if (response.success) {
                    // Replace content in editor
                    setEditorContent(response.data.content);
                    
                    // Show success message
                    showSuccessMessage(response.data.message);
                } else {
                    alert('Error: ' + (response.data || 'Unknown error occurred'));
                }
            },
            error: function(xhr, status, error) {
                hideLoadingState();
                console.error('AI Enhancement Error:', error);
                
                if (status === 'timeout') {
                    alert('The enhancement is taking longer than expected. Please try again with shorter content.');
                } else {
                    alert(aiEnhancer.error_text);
                }
            }
        });
    }
    
    function getCurrentEditorContent() {
        // Check if we're in Classic Editor (TinyMCE) or Text mode
        if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
            return tinymce.get('content').getContent();
        } else if ($('#content').length) {
            // Text editor mode
            return $('#content').val();
        }
        return '';
    }
    
    function setEditorContent(content) {
        // Set content in appropriate editor
        if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
            tinymce.get('content').setContent(content);
        } else if ($('#content').length) {
            $('#content').val(content);
        }
    }
    
    function showLoadingState(type) {
        isProcessing = true;
        
        var actionText = 'Enhancing';
        switch(type) {
            case 'enrich':
                actionText = 'Enriching';
                break;
            case 'faq':
                actionText = 'Adding FAQ section';
                break;
            case 'seo':
                actionText = 'Improving SEO';
                break;
        }
        
        // Add loading overlay to editor
        var editorContainer = $('#postdivrich') || $('#content').parent();
        if (editorContainer.length) {
            editorContainer.addClass('ai-enhancer-loading');
        }
        
        // Update button state
        $('.ai-blogger-tools-btn')
            .prop('disabled', true)
            .html('<span class="dashicons dashicons-update-alt" style="margin-right: 5px; animation: ai-spin 1s linear infinite;"></span>' + actionText + '...');
    }
    
    function hideLoadingState() {
        isProcessing = false;
        
        // Remove loading overlay
        $('#postdivrich, #content').parent().removeClass('ai-enhancer-loading');
        
        // Restore button state
        $('.ai-blogger-tools-btn')
            .prop('disabled', false)
            .html('<span class="dashicons dashicons-admin-generic" style="margin-right: 5px;"></span>Content AI Tools<span class="dashicons dashicons-arrow-down-alt2" style="margin-left: 5px; font-size: 12px;"></span>');
    }
    
    function showSuccessMessage(message) {
        // Create and show success notification
        var notification = $('<div class="notice notice-success is-dismissible ai-enhancer-notice" style="margin: 10px 0;"><p><strong>AI Enhancement Complete:</strong> ' + message + '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>');
        
        // Add to the top of the page
        if ($('.wrap h1').length) {
            notification.insertAfter('.wrap h1');
        } else {
            notification.prependTo('.wrap');
        }
        
        // Handle dismiss button
        notification.find('.notice-dismiss').on('click', function() {
            notification.fadeOut(300, function() {
                $(this).remove();
            });
        });
        
        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            notification.fadeOut(300, function() {
                $(this).remove();
            });
        }, 5000);
    }
    
    // Handle TinyMCE initialization
    $(document).on('tinymce-editor-init', function(event, editor) {
        // Ensure our button functionality works after TinyMCE loads
        // TinyMCE initialized for AI Post Enhancer
    });
}); 