# Email Templates for Sica Content AI

## Preview Files

Open these HTML files in a browser to preview and iterate on designs:

- **`post-created-preview.html`** - Full-featured design with image, stats, and share buttons
- **`post-created-minimal.html`** - Ultra-minimal, scannable in 3 seconds

## Best Practices for SMB Owner Notifications

### 1. **Scannable in 3 Seconds**
Busy owners check email on the go. They need to:
- See success/failure status immediately (visual indicator)
- Know what was created (title)
- Take action with one tap (View button)

### 2. **Show Value, Not Just Status**
SMB owners care about:
- **Word count** - Shows content is substantial
- **Read time** - Helps them plan review
- **SEO status** - Confirms the post is optimized
- **Featured image** - Visual proof of quality

### 3. **One Primary Action**
Make the "View Post" button unmissable:
- Large, colorful, high contrast
- Action-oriented text ("View Post →" not "Click here")
- Above the fold on mobile

### 4. **Social Sharing Integration**
Many SMB owners want to promote new content:
- Pre-built share links for Twitter, LinkedIn, Facebook
- Saves them time crafting social posts
- Increases the value of each AI-generated article

### 5. **Clear Status Badges**
- **Green checkmark** = Published, live on site
- **Amber badge** = Draft, needs review
- Color-coded for instant recognition

### 6. **Mobile-First Design**
- 60%+ of SMB owners check email on phones
- Single-column layout
- Large touch targets (44px minimum)
- Readable font sizes (15px+ body)

### 7. **Respect Their Time**
What to REMOVE:
- ❌ Long explanatory text
- ❌ Multiple equally-weighted CTAs
- ❌ Technical jargon
- ❌ Unnecessary branding

What to KEEP:
- ✅ Post title (hero element)
- ✅ One clear CTA
- ✅ Quick secondary links
- ✅ Essential metadata only

## Recommended Email Content

### Subject Lines (A/B test these)
```
✅ New post: "How Missed Call Text Back Boosts Customer Service"
✅ [Published] Your AI article is live
✅ 📝 New blog post ready on Sica Marketing
❌ Sica Content AI Notification - Post Created Successfully
```

### Preview Text (first 90 chars visible in inbox)
```
✅ "How Missed Call Text Back Boosts Saskatoon Customer Service" is now live. View it →
✅ Your new article (1,247 words, 6 min read) is published and SEO-optimized.
```

## Implementation Notes

### Variables to Pass from PHP

```php
$email_data = [
    'headline' => 'A new post was published!',
    'title' => get_the_title($post_id),
    'excerpt' => wp_trim_words(get_the_excerpt($post_id), 25),
    'thumbnail_url' => get_the_post_thumbnail_url($post_id, 'medium'),
    'post_url' => get_permalink($post_id),
    'edit_url' => admin_url('post.php?post=' . $post_id . '&action=edit'),
    'word_count' => str_word_count(strip_tags(get_the_content(null, false, $post_id))),
    'status' => get_post_status($post_id),
    'site_name' => get_bloginfo('name'),
    'timestamp' => get_the_date('M j, Y \a\t g:i A T', $post_id),
    'mode' => 'Manual generation', // or 'Scheduled'
    // Social share URLs
    'share_twitter' => 'https://twitter.com/intent/tweet?url=' . urlencode($post_url) . '&text=' . urlencode($title),
    'share_linkedin' => 'https://www.linkedin.com/sharing/share-offsite/?url=' . urlencode($post_url),
    'share_facebook' => 'https://www.facebook.com/sharer/sharer.php?u=' . urlencode($post_url),
];
```

### Email Client Compatibility

- Use inline styles (not `<style>` tags)
- Use tables for complex layouts
- Test with Litmus or Email on Acid
- Gmail clips emails > 102KB - keep it light

## Email Compliance (CAN-SPAM / GDPR)

### Required Elements

1. **Why they're receiving the email**
   ```
   "You're receiving this because you have post notifications enabled in
   Sica Content AI → Settings → Notifications"
   ```

2. **Clear unsubscribe mechanism**
   - Link to notification settings in plugin
   - One-click "Turn off post emails" option
   - Must work without requiring login (use token-based links)

3. **Sender identification**
   - "Sica Content AI" as sender name
   - Valid reply-to address (team@sicamarketing.com)
   - Physical address if required by jurisdiction

### Best Practices

- Place compliance footer **outside** the main content card (visually distinct)
- Use smaller, muted text (11px, gray) - required but not the focus
- Link to full notification settings, not just unsubscribe
- Provide "Manage preferences" as first option (keeps them engaged)
- Include Help/Support link for questions

### PHP Implementation

```php
// Generate unsubscribe URL with token (no login required)
$unsubscribe_token = wp_hash($user_email . 'sica_unsubscribe');
$unsubscribe_url = admin_url('admin-ajax.php?action=sica_unsubscribe&email=' . urlencode($user_email) . '&token=' . $unsubscribe_token);

// Or link to settings page (requires login)
$settings_url = admin_url('admin.php?page=sica-content-ai&tab=notifications');
```

## Metrics to Track

1. **Open rate** - Is the subject line working?
2. **Click-through rate** - Are they viewing the post?
3. **Time to click** - How fast do they engage?
4. **Share button clicks** - Is this feature valued?

## Future Enhancements

- [ ] AI-generated social post suggestions
- [ ] Unsubscribe preferences (per notification type)
- [ ] Weekly digest option instead of per-post
- [ ] Performance metrics (views, engagement) in follow-up email
