<?php
/**
 * Subscription Interface Management
 * 
 * Handles subscription UI rendering and email verification interface
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render the subscription interface in the setup tab
 */
function sica_render_subscription_interface() {
    $customer_email = get_option('sica_customer_email', '');
    $email_verified = get_option('sica_email_verified', false);
    
    if (!$customer_email || !$email_verified): 
        // Show email verification flow
    ?>
    
    <!-- Email Verification Flow -->
    <div style="background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 25px; margin-bottom: 20px;">
        <div style="text-align: left; margin-bottom: 25px;">
            <h3 style="color: #1976d2; margin: 0 0 10px 0;">🎉 Welcome to Sica Content AI!</h3>
            <p style="color: #666; margin: 0; font-size: 16px;">Get 2 free AI blog posts per month - just verify your email</p>
        </div>
        
        <div id="verification_step_1" style="display: <?php echo $customer_email ? 'none' : 'block'; ?>;">
            <div style="background: #e3f2fd; padding: 20px; border-radius: 6px; margin-bottom: 20px;">
                <h4 style="color: #1976d2; margin: 0 0 10px 0;">✨ What you get FREE:</h4>
                <ul style="margin: 0; padding-left: 20px; color: #333;">
                    <li><strong>2 AI blog posts per month</strong></li>
                    <li><strong>Professional SEO optimization</strong></li>
                    <li><strong>Automatic featured images</strong></li>
                    <li><strong>Ready-to-publish content</strong></li>
                </ul>
            </div>
            
            <!-- Marketing Opt-in -->
            <div style="background: #f0f8ff; border: 1px solid #b3d9ff; border-radius: 6px; padding: 16px; margin-bottom: 20px;">
                <label style="display: flex; align-items: flex-start; gap: 10px; cursor: pointer; color: #1976d2; font-size: 14px;">
                    <input type="checkbox" id="marketing-consent" checked style="margin-top: 2px;">
                    <span>
                        <strong>Yes, send me helpful SEO and content strategy tips!</strong>
                        <br><small style="color: #666;">Get insider tips from sica.ai on growing your website with AI content. Unsubscribe anytime.</small>
                    </span>
                </label>
            </div>
            
            <div style="margin-bottom: 20px;">
                <label for="verification_email" style="font-weight: bold; display: block; margin-bottom: 8px;">
                    📧 Enter your email address:
                </label>
                <input type="email" id="verification_email" placeholder="your-email@example.com" 
                       autocomplete="off" autocapitalize="none" spellcheck="false" 
                       data-lpignore="true" data-form-type="other"
                       style="width: 100%; max-width: 400px; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px;" 
                       value="<?php echo esc_attr($customer_email); ?>">
                
                <!-- Email Purpose Notice -->
            </div>
            
            <button type="button" id="send_verification_btn" class="button button-primary button-large">
                Send Verification Code
            </button>
        </div>
        
        <div id="verification_step_2" style="display: <?php echo $customer_email ? 'block' : 'none'; ?>;">
            <div style="background: #e7f3ff; padding: 15px; border-radius: 6px; margin-bottom: 20px; border-left: 4px solid #2196f3;">
                <p style="margin: 0; color: #1565c0;">
                    <strong>📧 Click "Resend Code" to continue</strong><br>
                    We'll send a 6-digit verification code to: <strong id="verification_email_display"><?php echo esc_html($customer_email); ?></strong>
                </p>
            </div>
            
            <div style="margin-bottom: 20px;">
                <label for="verification_code" style="font-weight: bold; display: block; margin-bottom: 8px;">
                    🔢 Enter verification code:
                </label>
                <input type="text" id="verification_code" placeholder="••••••" maxlength="6" 
                       style="width: 150px; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 18px; text-align: center; letter-spacing: 2px; font-family: monospace;"
                       autocomplete="one-time-code" inputmode="numeric" pattern="[0-9]{6}">
                <style>
                #verification_code::placeholder { 
                    color: #ccc !important; 
                    opacity: 0.7; 
                }
                </style>
            </div>
            
            <div style="margin-bottom: 20px;">
                <button type="button" id="verify_email_btn" class="button button-primary button-large">
                    Verify & Activate Free Account
                </button>
                <button type="button" id="resend_code_btn" class="button" style="margin-left: 10px;">
                    Resend Code
                </button>
            </div>
            
            <p style="font-size: 14px; color: #666; margin: 0;">
                Wrong email? <a href="#" id="change_email_link">Change email address</a>
            </p>
        </div>
        
        <div id="verification_status" style="margin-top: 20px;"></div>
    </div>
    
    <?php else: 
        // Show subscription dashboard for verified users
        $dashboard_data = sica_get_usage_dashboard_data();
        if ($dashboard_data && is_array($dashboard_data)): 
    ?>
    
    <!-- Subscription Status Dashboard -->
    <div style="background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 20px; margin-bottom: 20px;">
        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 15px;">
            <h3 style="margin: 0; color: <?php echo isset($dashboard_data['tier_color']) ? esc_attr($dashboard_data['tier_color']) : '#198754'; ?>;">
                🎯 <?php echo isset($dashboard_data['tier_name']) ? esc_html($dashboard_data['tier_name']) : 'Free Tier'; ?>
            </h3>
            <?php if (defined('WP_DEBUG') && WP_DEBUG): ?>
                <span style="color: #ff6b35; font-weight: bold;">🔧 DEBUG MODE</span>
            <?php endif; ?>
        </div>
        
        <!-- Usage Progress -->
        <div style="margin-bottom: 15px;">
            <?php if (isset($dashboard_data['is_unlimited']) && $dashboard_data['is_unlimited']): ?>
                <div style="color: #198754; font-weight: bold; font-size: 16px;">
                    ∞ Unlimited Posts This Month
                </div>
                <small style="color: #666;">Agency tier includes unlimited content generation</small>
            <?php else: ?>
                <?php 
                $posts_remaining = isset($dashboard_data['posts_remaining']) ? $dashboard_data['posts_remaining'] : 3;
                $is_unlimited_posts = ($posts_remaining === -1);
                $is_unlimited_sites = (isset($dashboard_data['site_limit']) && $dashboard_data['site_limit'] === -1);
                $warning_class = '';
                $warning_icon = '';
                if ($posts_remaining == 0) {
                    $warning_class = 'color: #dc3545; font-weight: bold;';
                    $warning_icon = '';
                } elseif ($posts_remaining <= 2) {
                    $warning_class = 'color: #ffc107; font-weight: bold;';
                    $warning_icon = '';
                } else {
                    $warning_class = 'color: #198754; font-weight: bold;';
                    $warning_icon = '';
                }
                ?>
                <?php if ($is_unlimited_posts): ?>
                <div style="color: #059669; font-size: 16px; margin-bottom: 8px; font-weight: bold;">
                    🚀 Unlimited posts available
                </div>
                <div style="font-size: 14px; color: #666; margin-bottom: 10px;">
                    <?php echo esc_html(isset($dashboard_data['posts_used']) ? $dashboard_data['posts_used'] : 0); ?> posts generated this month
                    <?php if (isset($dashboard_data['try_again_count']) && $dashboard_data['try_again_count'] > 0): ?>
                        • <?php echo esc_html($dashboard_data['try_again_count']); ?> try-again(s) (free)
                    <?php endif; ?>
                </div>
                <?php else: ?>
                <div style="<?php echo esc_attr($warning_class); ?> font-size: 16px; margin-bottom: 8px;">
                    <?php echo wp_kses_post($warning_icon); ?>
                    <?php
                        /* translators: %d: number of posts remaining */
                        printf(
                            esc_html(_n('%d post remaining this month', '%d posts remaining this month', (int) $posts_remaining, 'sica-content-ai')),
                            (int) $posts_remaining
                        );
                    ?>
                </div>
                <div style="font-size: 14px; color: #666; margin-bottom: 10px;">
                    <?php echo esc_html(isset($dashboard_data['posts_used']) ? $dashboard_data['posts_used'] : 0); ?> of <?php echo esc_html(isset($dashboard_data['posts_limit']) ? $dashboard_data['posts_limit'] : 3); ?> posts used
                    <?php if (isset($dashboard_data['try_again_count']) && $dashboard_data['try_again_count'] > 0): ?>
                        • <?php echo esc_html($dashboard_data['try_again_count']); ?> try-again(s) (free)
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <!-- Progress Bar (hidden for unlimited posts accounts) -->
                <?php if (!$is_unlimited_posts): ?>
                <div style="background: #e9ecef; border-radius: 10px; height: 12px; width: 100%; max-width: 400px; overflow: hidden;">
                    <div style="
                        background: <?php 
                            if ($posts_remaining == 0) echo '#dc3545';
                            elseif ($posts_remaining <= 2) echo '#ffc107'; 
                            else echo '#198754';
                        ?>; 
                        height: 12px; 
                        border-radius: 10px; 
                        width: <?php echo esc_attr(isset($dashboard_data['usage_percentage']) ? $dashboard_data['usage_percentage'] : 0); ?>%;
                        transition: width 0.3s ease;
                    "></div>
                </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        
        <!-- Billing Period -->
        <div style="font-size: 12px; color: #666; margin-bottom: 15px;">
            📅 Billing period ends: <?php echo esc_html(isset($dashboard_data['billing_period_end']) ? date('M j, Y', strtotime($dashboard_data['billing_period_end'])) : 'Next month'); ?>
        </div>
        
        <!-- Action Buttons -->
        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
            <?php if (isset($dashboard_data['upgrade_required']) && $dashboard_data['upgrade_required']): ?>
                <button type="button" class="button button-primary" onclick="window.open('https://sica.ai/pricing', '_blank')">
                    Upgrade Plan
                </button>
            <?php elseif (isset($dashboard_data['overage_available']) && $dashboard_data['overage_available'] && $posts_remaining <= 2): ?>
                <button type="button" class="button button-secondary" onclick="alert('Overage purchase coming soon! $<?php echo esc_js(isset($dashboard_data['overage_price']) ? $dashboard_data['overage_price'] : '5'); ?> per additional post.')">
                    Buy Extra Posts ($<?php echo esc_html(isset($dashboard_data['overage_price']) ? $dashboard_data['overage_price'] : '5'); ?> each)
                </button>
            <?php endif; ?>
            
            <button type="button" class="button" onclick="window.open('https://sica.ai/pricing', '_blank')">
                View Upgrade Options
            </button>
            
            <button type="button" class="button" onclick="sicaLogoutEmail()" 
                    style="color: #666; border-color: #ddd;" 
                    title="Change to a different email address">
                Change Email Address
            </button>
        </div>
    </div>
    
    <?php else: ?>
        <div style="background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; padding: 20px;">
            <p style="color: #721c24; margin: 0;">
                <strong>Unable to load subscription data.</strong> Please try again later or contact support.
            </p>
        </div>
    <?php endif; ?>
    
    <?php endif;
}